const { getUserToken, getUserById } = require("../helpers/user");
const { openToken } = require("../helpers/jwt");
const { copulateUserData } = require("../helpers/dataManipulator");

exports.isNotAuthUser = async(req, res, next) => {
    const authHeader = req.headers['authorization'];
    
    if (authHeader) {
        // Extract the token from the header

        try {

            const token = await openToken(authHeader.split(' ')[1]);
            if (token) {
                const isOnDB = await getUserToken(authHeader.split(' ')[1]);
                if (!isOnDB) return res.json({ status: false, message: 'Login expired', action: "jwt" });
                return res.json({ status: false, message: 'Already Authorized', goto: "HomeScreen" });
            } else return next()

        } catch (error) {
            return next()
        }

    } else return next()  
}


exports.isAuthUser = async(req, res, next) => {
    const authHeader = req.headers['authorization'];

    if (authHeader) {
        // Extract the token from the header
        let token;

        try {
            token = await openToken(authHeader.split(' ')[1]);

            const isOnDB = await getUserToken(authHeader.split(' ')[1]);
            if (!isOnDB) return res.json({ status: false, message: 'Login expired', action: "jwt" });
            
            //Get Necessary Info
            const user = await getUserById(parseInt(token.id));
            if (!user) return res.json({ status: false, message: "Please Login First", action: "jwt" })

            if(!user.is_verify) return res.json({ status: false, message: "Please verify your account", action: "jwt" });

            //CopulateUserData
            req.user = await copulateUserData(user);

            return next()

        } catch (error) {
            return res.json({ status: false, message: "Login Expired", action: "jwt" })
        }


    } else return res.json({ status: false, message: "Please Login First", action: "jwt" })
    
}

exports.userInfo = async(req, res, next) => {
    const authHeader = req.headers['authorization'];

    if (authHeader) {
        // Extract the token from the header
        let token;

        try {
            token = await openToken(authHeader.split(' ')[1]);

            const isOnDB = await getUserToken(authHeader.split(' ')[1]);
            if (isOnDB){
                const user = await getUserById(parseInt(token.id));
                if (user){
                    req.user = await copulateUserData(user);
                }
            }

        } catch (error) {
            return next()
        }
    };

    return next()
}

