const asyncHandler = require("../helpers/asyncHandler");
const logger = require("../helpers/logger");
const { getGlobalCache } = require("../helpers/globalCache");

exports.generalData = asyncHandler(async (req, res, next) => {
  const { settings, categories, trendingCats, popularTags } = getGlobalCache();

  if (!settings || !Object.keys(settings).length) {
    logger.error("Web settings not available in cache");
    return res.status(500).json({ error: "Web settings not found" });
  }

  res.locals.shortUrl = req.originalUrl.split("?")[0];
  res.locals.longUrl = req.protocol + "://" + req.get("host") + req.originalUrl;
  res.locals.homeUrl = req.protocol + "://" + req.get("host");
  res.locals.protocol = req.protocol + "://";
  res.locals.host = req.get("host");

  res.locals.websiteDetails = settings;

  res.locals.formatDuration = function (durationInSec) {
    let formattedDuration = '';
    const hours = Math.floor(durationInSec / 3600);
    const minutes = Math.floor((durationInSec % 3600) / 60);
    const seconds = durationInSec % 60;

    if (durationInSec < 60) {
      formattedDuration = `${seconds} sec`;
    } else {
      if (hours > 0) formattedDuration += `${hours} h `;
      if (minutes > 0) formattedDuration += `${minutes} min`;
    }

    return formattedDuration.trim();
  };

  res.locals.isSingle = false;
  
  res.locals.title = `${settings.website_title} - ${settings.website_tagline}`;
  res.locals.description = settings.website_description || '';
  res.locals.thumbnail = ``;

  res.locals.allCategories = categories.categories || [];
  res.locals.countryCategories = categories.countries || [];
  res.locals.trendingCats = trendingCats;
  res.locals.popularTags = popularTags;

  res.locals.IS_DEV = process.env.NODE_ENV && process.env.NODE_ENV.trim() == "dev";
  
  next();
});
