const sharp = require("sharp");
const fs = require("fs");
const path = require("path");
const asyncHandler = require("../helpers/asyncHandler");
const { generateRandomId } = require("../helpers/uniqueID");
const mime = require('mime-types');

exports.fileAttachmentCompresser = asyncHandler(async (req, res, next) => {

    try {

        const compressedImgs = [];

        //Uploading Image
        if (req.files) {

            for (i = 0; i < req.files.length; i++) {

                //The File
                const file = req.files[i];

                if (!file.mimetype == "image/png" || !file.mimetype == "image/jpg" || !file.mimetype == "image/jpeg" || !file.mimetype == "image/webp") return res.json({ status: false, message: 'Only .png, .jpg, .webp and .jpeg format allowed!' })

                const random = generateRandomId();

                let webpBuffer = await sharp(file.buffer)
                        .rotate()
                        .resize({ fit: 'inside', withoutEnlargement: true })
                        .toFormat('webp', { quality: 80 })
                        .toBuffer();


                const pathName = '/img/attachment/' + random + '.webp';

                // Save the compressed and converted image
                fs.writeFileSync(path.join(__basedir, "public", pathName), webpBuffer);

                compressedImgs.push({
                    fieldname: file.fieldname,
                    pathUrl: pathName,
                    pathToFile: path.join(__basedir, "public", pathName)
                })
            }

        }

        req.compressedImgs = compressedImgs;
        next()

    } catch (error) {console.log(error)
        return res.json({ status: false, message: error.message });
    }



})

exports.anyFilesAttachmentCompresser = asyncHandler(async (req, res, next) => {
    try {
      const compressedFiles = [];
  
      if (req.files) {
        for (let i = 0; i < req.files.length; i++) {
          const file = req.files[i];
          const random = generateRandomId();
  
          const mimeType = file.mimetype;
  
          if (mimeType.startsWith("image/")) {
            // Compress image to .webp
            const webpBuffer = await sharp(file.buffer)
              .rotate()
              .resize({ width: 600, height: 600, fit: 'inside', withoutEnlargement: true })
              .toFormat('webp', { quality: 80 })
              .toBuffer();
  
            const pathName = `/files/${random}.webp`;
            fs.writeFileSync(path.join(__basedir, "public", pathName), webpBuffer);
  
            compressedFiles.push({
              fieldname: file.fieldname,
              pathUrl: pathName,
              pathToFile: path.join(__basedir, "public", pathName),
              fileType: mimeType
            });
  
          } else {
            // Save other files as-is with their original extension
            const ext = mime.extension(mimeType) || 'bin';
            const pathName = `/files/${random}.${ext}`;
            fs.writeFileSync(path.join(__basedir, "public", pathName), file.buffer);
  
            compressedFiles.push({
              fieldname: file.fieldname,
              pathUrl: pathName,
              pathToFile: path.join(__basedir, "public", pathName),
              fileType: mimeType
            });
          }
        }
      }
  
      req.compressedFiles = compressedFiles;
      next();
  
    } catch (error) {
      console.error(error);
      return res.json({ status: false, message: error.message });
    }
});

exports.anyFilesAttachmentBufferCompresser = asyncHandler(async (req, res, next) => {
  try {
    const compressedFiles = [];

    if (req.files) {
      for (let i = 0; i < req.files.length; i++) {
        const file = req.files[i];

        const mimeType = file.mimetype;

        if (mimeType.startsWith("image/")) {
          // Compress image to .webp
          const webpBuffer = await sharp(file.buffer)
            .rotate()
            .resize({ width: 600, height: 600, fit: 'inside', withoutEnlargement: true })
            .toFormat('webp', { quality: 80 })
            .toBuffer();

          compressedFiles.push({
            fieldname: file.fieldname,
            buffer: webpBuffer,
            fileType: mimeType
          });

        } else {
          
          compressedFiles.push({
            fieldname: file.fieldname,
            buffer: file.buffer,
            fileType: mimeType
          });
        }
      }
    }

    req.compressedFiles = compressedFiles;
    next();

  } catch (error) {
    console.error(error);
    return res.json({ status: false, message: error.message });
  }
});

exports.fileAttachmentCompresserBuffer = asyncHandler(async (req, res, next) => {

    try {

        const compressedImgs = [];

        //Uploading Image
        if (req.files) {

            for (i = 0; i < req.files.length; i++) {

                //The File
                const file = req.files[i];

                if (!file.mimetype == "image/png" || !file.mimetype == "image/jpg" || !file.mimetype == "image/jpeg" || !file.mimetype == "image/webp") return res.json({ status: false, message: 'Only .png, .jpg, .webp and .jpeg format allowed!' });

                let webpBuffer = await sharp(file.buffer)
                        .rotate()
                        .resize({ fit: 'inside', withoutEnlargement: true })
                        .toFormat('webp', { quality: 70 })
                        .toBuffer();


                compressedImgs.push({
                    fieldname: file.fieldname,
                    buffer: webpBuffer
                })
            }

        }

        req.compressedImgs = compressedImgs;
        next()

    } catch (error) {console.log(error)
        return res.json({ status: false, message: error.message });
    }



})
