const db = require("../models/db");

//CREATE NEW
exports.insertVideo = (obj) => {
    return new Promise((resolve, reject) => {
        db.query("INSERT INTO f_uploads SET ?", obj, (err, data) => {
            if (err) reject(err)
            else resolve(data)
        })
    })
};

//EDIT UPLOAD
exports.editUploadById = (uploadId, data) => {
    return new Promise((resolve, reject) => {
        db.query("UPDATE f_uploads SET ? WHERE u_id = ?", [data, uploadId], (err, data) => {
            if (err) reject(err)
            else resolve(data)
        })
    })
};

//GET UPLOAD BY ID
exports.getUploadById = (uploadId) => {
    return new Promise((resolve, reject) => {
        db.query("SELECT * FROM f_uploads WHERE u_id = ?", uploadId, (err, data) => {
            if (err) reject(err)
            else resolve(data[0])
        })
    })
};

//GET VIDEO UPLOADS
exports.getVideoUploads = (obj) => {
    return new Promise(async (resolve, reject) => {
        try {
            // Build dynamic filters
            let filters = `WHERE 1 + 1`;

            if (obj.query.search) {
                filters += ` AND (u_title LIKE '%${obj.query.search}%' OR u_description LIKE '%${obj.query.search}%')`;
            }

            // Build SQL queries for pagination
            const query = `SELECT * FROM f_uploads ${filters} LIMIT ${obj.query.limit} OFFSET ${obj.query.offset};`;
            
            const countQuery = `SELECT COUNT(*) as totalCount FROM f_uploads ${filters};`;

            const dbInstance = obj.connection || db;

            const [dataResult, countResult] = await Promise.all([
                new Promise((res, rej) => dbInstance.query(query, (err, data) => err ? rej(err) : res(data))),
                new Promise((res, rej) => dbInstance.query(countQuery, (err, data) => err ? rej(err) : res(data))),
            ]);

            return resolve({
                data: dataResult,
                totalCount: countResult[0].totalCount
            });

        } catch (err) {
            return reject(err);
        }
    });
};

//DELETE UPLOAD BY ID
exports.deleteUploadById = (uploadId) => {
    return new Promise((resolve, reject) => {
        db.query("DELETE FROM f_uploads WHERE u_id = ?", uploadId, (err, data) => {
            if (err) reject(err)
            else resolve(data)
        })
    })
};

// DELETE MULTIPLE SUBMISSION
exports.deleteUploads = (uploadIds) => {
    return new Promise((resolve, reject) => {
        if (!Array.isArray(uploadIds) || uploadIds.length === 0) {
            return resolve({ count: 0, deletedData: [] });
        }

        const sanitizedIds = uploadIds.map(id => parseInt(id)).filter(id => !isNaN(id));
        if (sanitizedIds.length === 0) {
            return resolve({ count: 0, deletedData: [] });
        }

        const placeholders = sanitizedIds.map(() => '?').join(',');

        // Fetch users first
        db.query(
            `SELECT * FROM f_uploads WHERE u_id IN (${placeholders})`,
            sanitizedIds,
            (fetchErr, deletedData) => {
                if (fetchErr) return reject(fetchErr);

                if (deletedData.length === 0) return resolve({ count: 0, deletedData: [] });

                // Proceed to delete
                db.query(
                    `DELETE FROM f_uploads WHERE u_id IN (${placeholders})`,
                    sanitizedIds,
                    (deleteErr, result) => {
                        if (deleteErr) return reject(deleteErr);
                        resolve({ deletedRows: result.affectedRows, deletedData });
                    }
                );
            }
        );
    });
};