//GET NEXT OFFSET
exports.getNextOffset = (currentPage,limit) => {
    if (currentPage) {
        let page = parseInt(currentPage);
        
        if (page <= 1) {
            return 0
        } else {
            return (page - 1) * (parseInt(limit) || parseInt(process.env.LIMIT))
        }
    } else {
        return 0
    }
}



exports.paginateData = (limit, totalItems) => {
    let arr = [];

    for (i = 1; i <= Math.ceil(totalItems / parseInt(limit)); i++){
        arr.push(i)
    }
    return arr
}

exports.getNavData = (limit, currentPage, itemLength) => {
    const pageArr = this.paginateData(limit, itemLength);

    let nextPage = null

    //Next
    if (pageArr[pageArr.length - 1] > currentPage) {
        nextPage = currentPage + 1
    };

    return nextPage
}


exports.getPaginationNextPrev = (obj) => {

    obj.page = parseInt(obj.page);
    obj.limit = parseInt(obj.limit);
    obj.totalCount = parseInt(obj.totalCount);
    
    let prevPage, nextPage;

    //Prev
    if (obj.page > 1) prevPage = obj.page - 1;

    //Next
    const pageData = this.paginateData(obj.limit, obj.totalCount);
    if (obj.page && pageData[pageData.length - 1] > obj.page) nextPage = obj.page + 1;

    return { prevPage, nextPage, totalPages: pageData };
}