const db = require("../models/db");

exports.adminGetLogs = (obj) => {
    return new Promise(async (resolve, reject) => {
        try {
            // Build dynamic filters
            let filters = `WHERE 1 + 1`;
            if (obj.query.type && obj.query.type !== 'all') {
                filters += ` AND l_type = '${obj.query.type}'`;
            }
            if (obj.query.search) {
                filters += ` AND (l_message LIKE '%${obj.query.search}%' OR l_stack LIKE '%${obj.query.search}%' OR l_context LIKE '%${obj.query.search}%')`;
            }

            // Build SQL queries for pagination
            const query = `SELECT * FROM f_logs ${filters} ORDER BY l_id DESC LIMIT ${obj.query.limit} OFFSET ${obj.query.offset};`;
            
            const countQuery = `SELECT COUNT(*) as totalCount FROM f_logs ${filters};`;

            const dbInstance = obj.connection || db;

            const [dataResult, countResult] = await Promise.all([
                new Promise((res, rej) => dbInstance.query(query, (err, data) => err ? rej(err) : res(data))),
                new Promise((res, rej) => dbInstance.query(countQuery, (err, data) => err ? rej(err) : res(data))),
            ]);

            return resolve({
                logs: dataResult,
                totalCount: countResult[0].totalCount
            });

        } catch (err) {
            return reject(err);
        }
    });
};

//CLEAR ALL LOGS
exports.clearAllLogs = () => {
    return new Promise((resolve, reject) => {
        db.query("DELETE FROM f_logs", (err, data) => {
            if (err) reject(err)
            else resolve(data)
        })
    })
};