const jwt = require("jsonwebtoken");
const { getUserToken } = require("./user");
const { getAdminToken } = require("./admin");

exports.signToken = (data, options = {}) => {
    return new Promise((resolve, reject) => {
        try {
        const tk = jwt.sign(data, process.env.TOKEN_SECRET, options);
        resolve(tk)
        } catch (error) {
            reject(error)
        }
    })
}

exports.signResetPasswordToken = (obj,time = '1d') => {
    return new Promise((resolve, reject) => {
        try {
            
        const tk = jwt.sign(obj, process.env.TOKEN_SECRET,{expiresIn:time});
        resolve(tk)
        } catch (error) {
            reject(error)
        }
    })
}

exports.signNewToken = (obj,time = '1d',signature) => {
    return new Promise((resolve, reject) => {
        try {
            
        const tk = jwt.sign(obj, signature,{expiresIn:time});
        resolve(tk)
        } catch (error) {
            reject(error)
        }
    })
}


exports.openToken = (token) => {
    return new Promise((resolve, reject) => {
        try {
            const tk = jwt.verify(token, process.env.TOKEN_SECRET);
        resolve(tk)
        } catch (error) {
            reject(error)
        }
    })
}

exports.signObjToken = (obj) => {
    return new Promise((resolve, reject) => {
        try {
        const tk = jwt.sign(obj, process.env.TOKEN_SECRET);
        resolve(tk)
        } catch (error) {
            reject(error)
        }
    })
}

exports.getTokenFromHeader = async (socket, namespace) => {
    try {

        let token = socket.handshake.headers.authorization;

        if (!token) token = socket.handshake.query.token;

        if (token) {
            const { id: userId } = await this.openToken(token);

            let isOnDB;

            if(namespace == "/admin-ns"){
                isOnDB = await getAdminToken(token)
            }else{
                isOnDB = await getUserToken(token);
            };
            
            if (!isOnDB) return null;
            
            if(namespace == "/user-ns"){
                if(!isOnDB.is_verify) return null;
            }
            
            return userId || null;
        }
    } catch (error) {
    }
    return null;
};