const db = require("../models/db");
const { getPostCategoriesForUser, getTrendingCategories, getPopularTagsThisMonth } = require("./post");
const { getWebSettings } = require("./settings");

let cache = {
  settings: null,
  categories: { categories: [], countries: [] },
  trendingCats: [],
  popularTags: [],
  lastUpdated: 0
};

const REFRESH_INTERVAL_MS = 10 * 60 * 1000;

const refreshCache = async () => {
  try {
    const [settings, categories, trendingCats, popularTags] = await Promise.all([
      getWebSettings(),
      getPostCategoriesForUser(),
      getTrendingCategories(7),
      getPopularTagsThisMonth(30)
    ]);

    cache.settings = settings;
    cache.categories = categories;
    cache.trendingCats = trendingCats;
    cache.popularTags = popularTags;
    cache.lastUpdated = Date.now();

    console.log("✅ Global cache refreshed.");
  } catch (err) {
    console.error("❌ Failed to refresh global cache:", err);
  }
};

const initCache = async () => {
  try {
    // Wait until DB is ready
    await db.getConnectionPromise();
    console.log("✅ DB is ready, starting cache...");

    // First cache load
    await refreshCache();

    // Then set interval
    setInterval(refreshCache, REFRESH_INTERVAL_MS);
  } catch (err) {
    console.error("❌ Failed to initialize cache because DB isn't ready:", err);
    process.exit(1); // Optional: exit app if DB connection fails
  }
};

initCache();

module.exports = { getGlobalCache: () => cache };
