const geoip = require("geoip-lite");
const { countries } = require("../extras/country");

exports.getGeo = (req, type) => {
  return new Promise(async (resolve, reject) => {
    try {
      const ip = type == "ip" ? req : req.headers['x-forwarded-for'] ? (req.headers['x-forwarded-for'].split(",")[0]) : null

      const geo = geoip.lookup(ip);

      let country;

      if (geo) {
        country = countries.find((ct) => ct.iso2 === geo.country);
      }

      resolve({ timeZone: geo ? geo.timezone : '', country});
    } catch (error) {
      reject(error);
    }
  });
};
