const yup = require('yup');

exports.buyAirtimeSchema = yup.object().shape({
  network: yup
    .mixed()
    .test(
      'is-string-or-number',
      'Network must be a string or a number',
      value => typeof value === 'string' || typeof value === 'number'
    )
    .required('Network is required'),
  
  phone: yup
    .string()
    .required('Phone number is required'),

  amount: yup
    .number()
    .positive('Amount must be a positive number')
    .required('Amount is required')
});

exports.buyDataSchema = yup.object().shape({
  network: yup
    .mixed()
    .test(
      'is-string-or-number',
      'Network must be a string or a number',
      value => typeof value === 'string' || typeof value === 'number'
    )
    .required('Network is required'),
    
  phone: yup
    .string()
    .required('Phone number is required'),
  
  planId: yup
    .string()
    .required('Data plan ID is required')
});

/* ELECTRICITY SCHEMA */
exports.buyElectricitySchema = yup.object().shape({
  meterType: yup
    .string()
    .oneOf(['prepaid', 'postpaid'], 'Meter type must be either prepaid or postpaid')
    .required('Meter type is required'),

  provider: yup
    .string()
    .required('Provider is required'),

  meterNumber: yup
    .string()
    .required('Meter number is required'),

  phone: yup
    .string()
    .required('Phone number is required'),

  amount: yup
    .number()
    .typeError('Amount must be a number')
    .positive('Amount must be a positive number')
    .required('Amount is required'),
});

//PAY CABLETV SCHEMA
exports.payCableTvSchema = yup.object().shape({
  cableProvider: yup.string().required('Cable provider is required'),
  cableNumber: yup.string().required('Cable number is required'),
  cablePlanId: yup.string().required('Cable plan ID is required'),
  cableHolderName: yup.string().optional(),
  cableSubscriptionType: yup.string().required('Subscription type is required'),
  phone: yup.string().optional()
});


//BUYSELL GIFTCARD SCHEMA
exports.buySellGiftcardSchema = yup.object().shape({
  type: yup.string().oneOf(['buy', 'sell'], 'Select either buy or sell for giftcard transaction').required('Transaction type is required'),
  giftcardId: yup.string().required('Giftcard ID is required'),
  faceValue: yup.number().typeError('Amount must be a number').positive('Amount must be a positive number').required('Amount is required'),
  quantity: yup.number().required('Card quantity is required').positive('Card quantity must be a positive number').min(1, "Card minimum quantity should be 1")
});

//PAY EXAM RESULT SCHEMA
exports.payExamResultCheckerSchema = yup.object().shape({
  examType: yup.string().required('Exam type is required'),
  examPackageId: yup.string().required('Exam package ID is required'),
  pinQuantity: yup.string().required('PIN quantity is required').min(1, "Pin minimum quantity should be 1"),
  phone: yup.string().optional()
});

//PAY EXAMS REGISTRATION SCHEMA
exports.payExamRegistrationSchema = yup.object().shape({
  examProvider: yup.string().required('Exam provider is required'),
  examType: yup.string().required('Specify the type of exam'),
  examProfileId: yup.string().required('Exam profile ID is required'),
  phone: yup.string().optional()
});


exports.generateApiKeySchema = yup.object().shape({
  businessName: yup.string().required("Business name is required"),
  usageType: yup.string().required("Usage type is required"),
  websiteLink: yup.string().url("Enter a valid URL").required("Website link is required"),
});