const axios = require("axios");
const { HttpError } = require("./error");

const axiosInstance = axios.create({
    headers: {
        "Content-Type": "application/json"
    },
});

const fetcher = async (options, onUploadProgress) => {
    try {
        const response = await axiosInstance({
            ...options,
            onUploadProgress,
            headers: { ...options.headers },
        });
        return response.data; // Return successful response data
    } catch (error) {
        if (error.response) {
            // Server responded with a status code outside 2xx
            throw new HttpError({
                statusCode: error.response.status,
                message: error.response.data?.message || "Something went wrong",
                hint: error.response.data || "Check API response for details",
            });
        } else if (error.request) {
            // Request was made but no response received
            throw new HttpError({
                statusCode: 500,
                message: "No response received from the server.",
                hint: "The server might be down or unreachable.",
            });
        } else {
            // Something went wrong while setting up the request
            throw new HttpError({
                statusCode: 500,
                message: error.message,
                hint: "Check your request configuration.",
            });
        }
    }
};

module.exports = { fetcher };
