const { IOObj, NAMESPACES } = require("../socket-connection");
const { getDataFromObject } = require("./dataManipulator");
const { getUserEssentials } = require("./user");

exports.ioSendBalanceUpdate = (obj) => {
    return new Promise(async (resolve, reject) => {
        
        let userBalance = await getUserEssentials({ userId: obj.userId, connection: obj.connection })

        if(userBalance){

            userBalance = getDataFromObject(userBalance, ["ue_deposit_balance", "ue_referral_balance"]);

            //Emit Socket Event
            IOObj.namespaces[NAMESPACES.USER].sockets.get(String(obj.userId))?.emit("balance-updates", userBalance);
        }
        
        return resolve()
    })
}

//SEND SYSTEM NOTIFICATION
exports.ioSendSystemNotification = (obj) => {
    return new Promise(async (resolve, reject) => {
        
        //Emit Socket Event
        IOObj.namespaces[NAMESPACES.USER].sockets.get(String(obj.sn_user_id))?.emit("system-notification", obj);
        
        return resolve()
    })
}