//Calculate Percentage
exports.calculatePercentage = (percentageValue,amountValue) => {
    return (parseFloat(percentageValue) / 100) * amountValue
}

// Helper function to calculate a performance score (0-100)
exports.calculatePerformanceScore = function(referrer) {
    const activityScore = Math.min(referrer.total_referrals * 2, 50);
    const revenueScore = Math.min(referrer.total_revenue / 100, 30);
    const recencyScore = referrer.last_referral_date === 'Never' 
        ? 0 
        : 20 - (Math.floor((new Date() - new Date(referrer.last_referral_date)) / (1000 * 60 * 60 * 24)) / 2);
    
    return Math.min(Math.round(activityScore + revenueScore + recencyScore), 100);
}