const db = require("../models/db");

//CREATE NEW BANK ACCOUNT
exports.createNewBankAccount = (obj) => {
  return new Promise((resolve, reject) => {
    db.query("INSERT INTO f_bank_accounts SET ?", obj, (err, data) => {
      if (err) reject(err)
      else resolve(data)
    })
  })
};

//DELETE USER BANK ACCOUNT
exports.deleteUserBankAccount = (userId, bankAccountId) => {
  return new Promise((resolve, reject) => {
    db.query("DELETE FROM f_bank_accounts WHERE ba_user_id = ? AND ba_id = ?", [userId, bankAccountId], (err, data) => {
      if (err) reject(err)
      else resolve(data)
    })
  })
};

//GET USER BANK ACCOUNTS
exports.getUserBankAccounts = (userId) => {
  return new Promise((resolve, reject) => {
    db.query("SELECT * FROM f_bank_accounts WHERE ba_user_id = ?", userId, (err, data) => {
      if (err) reject(err)
      else resolve(data)
    })
  })
};

//GET USER BANK ACCOUNT BY ACCOUNT ID
exports.getUserBankAccountById = (userId, accountId) => {
  return new Promise((resolve, reject) => {
    db.query("SELECT * FROM f_bank_accounts WHERE ba_user_id = ? AND ba_id = ?", [userId, accountId], (err, data) => {
      if (err) reject(err)
      else resolve(data[0])
    })
  })
};