const db = require("../models/db");

//CREATE ADS
exports.createAd = (obj) => {
    return new Promise((resolve, reject) => {
        db.query("INSERT INTO f_ads SET ?", obj, (err, data) => {
            if (err) reject(err)
            else resolve(data)
        })
    })
};

//GET ALL AD
exports.adminGetAllAd = () => {
    return new Promise((resolve, reject) => {
        db.query("SELECT * FROM f_ads", (err, data) => {
            if (err) reject(err)
            else resolve(data)
        })
    })
};

//GET AD
exports.adminGetAd = (adId) => {
    return new Promise((resolve, reject) => {
        db.query("SELECT * FROM f_ads WHERE a_id = ?", adId, (err, data) => {
            if (err) reject(err)
            else resolve(data[0])
        })
    })
};

//EDIT AD
exports.adminEditAd = (adId, data) => {
    return new Promise((resolve, reject) => {
        db.query("UPDATE f_ads SET ? WHERE a_id = ?", [data, adId], (err, data) => {
            if (err) reject(err)
            else resolve(data)
        })
    })
};

//EDIT AD COUNT
exports.adminEditAdCount = (adId) => {
    return new Promise((resolve, reject) => {
        db.query("UPDATE f_ads SET a_total_click = a_total_click + 1 WHERE a_id = ?", adId, (err, data) => {
            if (err) reject(err)
            else resolve(data)
        })
    })
};

// GET MULTIPLE ADS
exports.getAdsById = (adsIds) => {
    return new Promise((resolve, reject) => {
        // Check if adsIds is an array and not empty
        if (!Array.isArray(adsIds) || adsIds.length === 0) {
            return resolve(0); // Return 0 if no users to delete
        }

        // Convert all IDs to numbers to prevent SQL injection
        const sanitizedIds = adsIds.map(id => parseInt(id)).filter(id => !isNaN(id));
        
        if (sanitizedIds.length === 0) {
            return resolve(0); // Return 0 if no valid IDs
        }

        // Create placeholders for the query (?, ?, ? etc.)
        const placeholders = sanitizedIds.map(() => '?').join(',');
        
        db.query(
            `SELECT * FROM f_ads WHERE a_id IN (${placeholders})`,
            sanitizedIds,
            (err, result) => {
                if (err) {
                    reject(err);
                } else {
                    resolve(result);
                }
            }
        );
    });
};

// DELETE MULTIPLE ADS
exports.deleteAds = (adsIds) => {
    return new Promise((resolve, reject) => {
        // Check if adsIds is an array and not empty
        if (!Array.isArray(adsIds) || adsIds.length === 0) {
            return resolve(0); // Return 0 if no users to delete
        }

        // Convert all IDs to numbers to prevent SQL injection
        const sanitizedIds = adsIds.map(id => parseInt(id)).filter(id => !isNaN(id));
        
        if (sanitizedIds.length === 0) {
            return resolve(0); // Return 0 if no valid IDs
        }

        // Create placeholders for the query (?, ?, ? etc.)
        const placeholders = sanitizedIds.map(() => '?').join(',');
        
        db.query(
            `DELETE FROM f_ads WHERE a_id IN (${placeholders})`,
            sanitizedIds,
            (err, result) => {
                if (err) {
                    reject(err);
                } else {
                    // Return the number of affected (deleted) rows
                    resolve(result.affectedRows);
                }
            }
        );
    });
};

//USER GET ADS
exports.userGetAds = (obj) => {
    return new Promise((resolve, reject) => {
        db.query(`SELECT * FROM f_ads WHERE ${obj.position ? `a_position = "${obj.position}" AND` : ''} a_environment = "${obj.environment}" AND (a_for = "${obj.userType}" OR a_for = "all") AND a_status = 'active' ORDER BY a_id DESC`, (err, data) => {
            if (err) reject(err)
            else resolve(data)
        })
    })
};