const asyncHandler = require("../../../helpers/asyncHandler");
const { insertContentRemoval } = require("../../../helpers/contentRemoval");
const { signResetPasswordToken, openToken } = require("../../../helpers/jwt");

//CONTENT REMOVAL PAGE
exports.contentRemovalPageGet = asyncHandler(async (req, res, next) => {

    const webSettings = res.locals.websiteDetails;

    let isTokenValid = false;
    try {
        if(req.query.token) {
            try {
                isTokenValid = await openToken(req.query.token);
            } catch (error) {
                isTokenValid = false;
            }
        }
    } catch (error) {
        
    }

    if(isTokenValid) {

        return res.render("general/page/Page/success", {
            title: `Request Submitted - ${webSettings.website_title}`,
            description: webSettings.website_description,
            token: req.query.token
        });
    }
    else{
        return res.render("general/page/Page/content-removal",{
            title: `Content Removal Form - ${webSettings.website_title}`,
            description: webSettings.website_description
        })
    }
    

})

//CONTENT REMOVAL PAGE (POST)
exports.contentRemovalPagePost = asyncHandler(async (req, res, next) => {

    await insertContentRemoval({
        cr_fullname: req.body.fullname,
        cr_email: req.body.email,
        cr_links: req.body.urls,
        cr_reason: req.body.reason,
        cr_additional: req.body.additional_info,
    });

    const token = await signResetPasswordToken(req.body, "30s");

    return res.redirect("?token=" + token);

})