const asyncHandler = require("../../../helpers/asyncHandler");
const { createNewsletterSubscriber } = require("../../../helpers/newsletter")

//NEWSLETTER SUBSCRIPTION (POST)
exports.newsletterSubscriptionPost = asyncHandler(async (req, res, next) => {

    try {
        await createNewsletterSubscriber({
            ns_email: req.body.email
        });
        
        return res.json({ status: true, message: "Thanks For Subscribing"})
    } catch (error) {
        
        let message;

        if (error.sqlMessage?.includes("ns_email")) {
            message = "You've already subscribed with this e-mail"
        } else message = error?.sqlMessage || "Something went wrong";

        return res.json({ status: false, message })

    }

})