const asyncHandler = require("../../../helpers/asyncHandler");
const formatNumber = require("../../../helpers/formatNumber");
const { getNextOffset, getPaginationNextPrev } = require("../../../helpers/pagination");
const { getTrendingCategoryPosts, getHotTrendingPosts2 } = require("../../../helpers/post");
const url = require('url');
const { getWebSettings } = require("../../../helpers/settings");


//TRENDING
exports.trendingGet = asyncHandler(async (req, res, next) => {
  const limit = parseInt(req.query.limit) || parseInt(process.env.LIMIT) || 2;
  const currentPage = parseInt(req.query.page) || 1;
  const offset = getNextOffset(currentPage, limit);

  const [ { totalCount, posts }, webSettings ] = await Promise.all([
    getHotTrendingPosts2({ query: { limit, offset } }),
    getWebSettings()
  ]);

  const { prevPage, nextPage, totalPages } = getPaginationNextPrev({ page: currentPage, limit, totalCount });

  const currentUrl = url.parse(req.originalUrl).pathname;
  let paginationLink = currentUrl;
  paginationLink = `?`;

  const categoriesPosts = await getTrendingCategoryPosts(JSON.parse(webSettings.website_fallback_categories), 5, 20);

  // Format the posts for rendering

  const { website_title } = webSettings;

  let homeTitle = "";
  if (posts.length) {
    homeTitle = `Trending: ${posts[0].c_title}`;
  }else {
    homeTitle = `Trending Posts`;
  }

  return res.render("general/page/Blog/trending", {
    title: `${homeTitle} - ${website_title}`,
    thumbnail: (posts[Math.floor(Math.random() * posts.length)] || {}).c_thumbnail,
    data: {
      posts: posts.map(post => ({ ...post, c_likes2: formatNumber(post.c_likes) })),
      pagination: {
        currentPage,
        prevPage,
        nextPage,
        totalPages,
        paginationLink
      },
      categoriesPosts
    }
  });
});

