const asyncHandler = require("../../../helpers/asyncHandler");
const formatNumber = require("../../../helpers/formatNumber");
const { getNextOffset, getPaginationNextPrev } = require("../../../helpers/pagination");
const { getPostsByTag } = require("../../../helpers/post");
const url = require('url');
const { getWebSettings } = require("../../../helpers/settings");


//TAG
exports.tagGet = asyncHandler(async (req, res, next) => {
  const limit = parseInt(req.query.limit) || parseInt(process.env.LIMIT) || 2;
  const currentPage = parseInt(req.query.page) || 1;
  const tag = req.params.tag;
  const offset = getNextOffset(currentPage, limit);

  const production = req.query.production, quality = req.query.quality, duration = req.query.duration, sortBy = req.query.sortBy || 'latest'

  const [ { posts, totalCount }, webSettings ] = await Promise.all([
    getPostsByTag({ query: { tag, quality, duration, production, sortBy,limit, offset } }),
    getWebSettings()
  ]);

  const { prevPage, nextPage, totalPages } = getPaginationNextPrev({ page: currentPage, limit, totalCount });
  const currentUrl = url.parse(req.originalUrl).pathname;
  const queryParams = [];

  // Add each parameter if it exists
  if (tag) queryParams.push(`tag=${encodeURIComponent(tag)}`);
  if (quality && quality !== 'any') queryParams.push(`quality=${encodeURIComponent(quality)}`);
  if (duration && duration !== 'any') queryParams.push(`duration=${encodeURIComponent(duration)}`);
  if (production && production !== 'any') queryParams.push(`production=${encodeURIComponent(production)}`);
  if (sortBy && sortBy !== 'any') queryParams.push(`sortBy=${encodeURIComponent(sortBy)}`);

  // Construct the pagination link
  const paginationLink = `${currentUrl}?${queryParams.join('&')}&`;

  return res.render("general/page/Blog/tag", {
    title: `Posts tagged with "${tag}" - ${webSettings.website_title}`,
    thumbnail: (posts[Math.floor(Math.random() * posts.length)] || {}).c_thumbnail || '',
    description: `Browse posts tagged with "${tag}" on ${webSettings.website_title}`,
    tag,
    totalCount,
    data: {
      posts: posts.map(post => ({ ...post, c_likes2: formatNumber(post.c_likes) })),
      pagination: { currentPage, prevPage, nextPage, totalPages, paginationLink }
    }
  });

});

