const { LIKES_MULTIPLIER, VIEW_MULTIPLIER } = require("../../../extras/constants");
const asyncHandler = require("../../../helpers/asyncHandler");
const { stripTextFromHtml, getVideoRenditions } = require("../../../helpers/dataManipulator");
const formatNumber = require("../../../helpers/formatNumber");
const { openToken } = require("../../../helpers/jwt");
const { getPostDetailsBySlug, getYouMayAlsoLikePosts } = require("../../../helpers/post");
const moment = require('moment');
const path = require("path")
const { ensureLocalHlsStream } = require("../../../helpers/s3");
const { formatDurationToIso8601 } = require("../../../helpers/dateTime");

//SINGLE POST
exports.singlePostGet = asyncHandler(async (req, res, next) => {

    try {
        
        const { slug } = req.params;
        let post, token;
        
        if(req.query.token) token = await openToken(req.query.token);
        
        post = await getPostDetailsBySlug(slug ?? '', Boolean(token));

        if (!post) {
            return res.status(404).render("general/page/404", { 
                title: "Resource Not Found",
                description: "The requested post could not be found."
            });
        }
        
        const youMayAlsoLikes = await getYouMayAlsoLikePosts(post.c_slug, 30);
        
        const webSettings = res.locals.websiteDetails;

        let description = stripTextFromHtml(post.c_description || '').substring(0, 160);
        if(description.length < 5) {
            description = stripTextFromHtml(webSettings.website_description || '').substring(0, 160);
        };
        
        let streamingLink = '', downloaded;
        
        try {
            const result = await ensureLocalHlsStream({
                videoId: post.c_download_id,
                localBaseDir: path.join(__basedir, 'public/files/videos'),
                relativePath: '/files/videos'
            });

            streamingLink = result.streamingLink;
            downloaded = result.downloaded;

        } catch (error) {
            
        }
        
        const downloadRenditions = getVideoRenditions(post.c_quality).reverse();
        
        return res.render("general/page/Blog/single",{
            title: `${post.c_title} - ${webSettings.website_title}`,
            description,
            thumbnail: `${res.locals.homeUrl}${post.c_thumbnail}`,
            isSingle: true,
            data: { 
                ...post, 
                isoVideoDuration: formatDurationToIso8601(post.c_duration),
                streamingLink,
                downloadRenditions,
                description: stripTextFromHtml(post.c_description || webSettings.website_description),
                c_likes: post.c_likes * LIKES_MULTIPLIER,
                c_likes2: formatNumber(post.c_likes * LIKES_MULTIPLIER), 
                c_views2: formatNumber(post.c_views * VIEW_MULTIPLIER), 
                formatDate: moment(post.c_created_at).format('MMM D, YYYY, h:mm A'),
                schemaDate: moment(post.c_created_at).format(),
                youMayAlsoLikes: youMayAlsoLikes.map(post => ({ ...post, c_likes2: formatNumber(post.c_likes * LIKES_MULTIPLIER) }))
            }
        })

    } catch (error) {console.log(error)
        return res.status(404).render("general/page/404", { 
            title: "Resource Not Found",
            description: "The requested post could not be found."
        });
    }
    
})