const { adminGetAdmins, getAdminActivities, updateAdminById, deleteAdmins, createAdmin } = require("../../../helpers/admin");
const asyncHandler = require("../../../helpers/asyncHandler");
const { getNextOffset, getPaginationNextPrev } = require("../../../helpers/pagination");
const { hashPassword } = require("../../../helpers/password");


//ADMIN ADMIN MANAGEMENT
exports.adminAdminManagementGet = asyncHandler(async (req, res, next) => {

    const limit = req.query.limit || parseInt(process.env.LIMIT), currentPage = parseInt(req.query.page) || 1, type = req.query.type || "all", search = req.query.search;

    const { totalCount, users } = await adminGetAdmins({
        query: { type, search, limit, offset: getNextOffset(currentPage, limit) },
        userId: req.user.uid
    });

    const { prevPage, nextPage, totalPages } = getPaginationNextPrev({ page: currentPage, limit, totalCount});


    res.json({ status: true, data: { users, pagination: { currentPage, prevPage, nextPage, totalPages } }})
});

//ADMIN ACTIVITIES
exports.adminAdminActivitiesGet = asyncHandler(async (req, res, next) => {

    const limit = req.query.limit || parseInt(process.env.LIMIT), currentPage = parseInt(req.query.page) || 1, from = req.query.from, to = req.query.to;

    const { totalCount, activities } = await getAdminActivities({
        query: { from, to, limit, offset: getNextOffset(currentPage, limit) },
        userId: req.query.id
    });

    const { prevPage, nextPage, totalPages } = getPaginationNextPrev({ page: currentPage, limit, totalCount});


    res.json({ status: true, data: { activities, pagination: { currentPage, prevPage, nextPage, totalPages } }})
    
});

//ADMIN CREATE ADMIN
exports.adminAdminManagementPost = asyncHandler(async (req, res, next) => {

    if(req.body.password) req.body.password = await hashPassword(req.body.password);
    
    const { insertId } = await createAdmin(req.body);

    res.json({ status: true, message: "User Created", data: { ...req.body, uid: insertId } })
    
});

//ADMIN UPDATE ADMIN
exports.adminAdminManagementPut = asyncHandler(async (req, res, next) => {

    if(req.body.password) req.body.password = await hashPassword(req.body.password);

    await updateAdminById(req.query.id, req.body);

    res.json({ status: true, message: "Changes Saved" })
    
});

//ADMIN DELETE ADMIN(s)
exports.adminAdminManagementDelete = asyncHandler(async (req, res, next) => {

    const deletedCount = await deleteAdmins(req.body);
    
    let message = "";
    if(deletedCount > 1) message = `${deletedCount} Users Deleted`
    else if(deletedCount == 1) message = "User Deleted";
    else message = "No User Deleted"

    res.json({ status: Boolean(deletedCount), message })
    
});
