const asyncHandler = require("../../../helpers/asyncHandler");
const { getContentRemovals } = require("../../../helpers/contentRemoval");
const { getScrappedContents } = require("../../../helpers/scrapped");
const { getVideoUploads } = require("../../../helpers/uploadVideo");

exports.adminMiscGet = asyncHandler(async (req, res, next) => {

    const [scrappedContents, contentRemovals, contentSubmissions] = await Promise.all([
        getScrappedContents({ query: { limit: 5e10, offset: 0 } }),
        getContentRemovals({ query: { status: 'pending', limit: 5e10, offset: 0 } }),
        getVideoUploads({ query: { limit: 5e10, offset: 0 } })
    ]);

    const data = {
        scrappedContent: scrappedContents?.totalCount || 0,
        contentRemovals: contentRemovals?.totalCount || 0,
        contentSubmissions: contentSubmissions?.totalCount || 0,
    };

    res.json({ status: true, data })
})

