const asyncHandler = require("../../../helpers/asyncHandler");
const { getAllMarketingTemplates, createMarketingTemplate, getMarketingTemplateById, updateMarketingTemplateById, deleteMarketingTemplates, getAllMarketingSchedules } = require("../../../helpers/marketing");
const { delayFn } = require("../../../helpers/promise");
const { getUniqueID } = require("../../../helpers/uniqueID");
const { deleteFileAttachmentMulter } = require("../../../multer/multerMiddleware");
const path = require("path")

exports.marketingCenterGet = asyncHandler(async (req, res, next) => {

    const [templates, schedules] = await Promise.all([
        getAllMarketingTemplates(),
        getAllMarketingSchedules()
    ]);

    return res.json({ status: true, data: { templates, schedules } })
})

exports.marketingTemplatesPost = asyncHandler(async (req, res, next) => {

    const attachments = req.compressedFiles.map(file => ({
        id: getUniqueID(),
        filename: file.fieldname,
        content: file.pathUrl,
        contentType: file.fileType
    }))

    const obj = {
        mt_name: req.body.name,	
        mt_subject: req.body.subject,
        mt_content: req.body.message,	
        mt_attachment: JSON.stringify(attachments.length ? attachments : []),
        mt_for: req.body.templateFor
    };

    const { insertId } = await createMarketingTemplate(obj);

    obj.mt_id = insertId;
    obj.mt_created_at = new Date();

    return res.json({ status: true, message: "Template created", data: obj })
})

exports.marketingTemplatesPut = asyncHandler(async (req, res, next) => {

    const template = await getMarketingTemplateById(req.body.id);
    if(!template) return res.json({ status: false, message: "Template not found or has been deleted"});

    const currentTemplateAttachments = JSON.parse(template.mt_attachment);
    const retainedAttachments = JSON.parse(req.body.retainedAttachments || '[]');

    const [sortedAttachments, deletedAttachments, newAttachments] = await Promise.all([
        Promise.resolve(currentTemplateAttachments.filter(ca => 
          retainedAttachments.find(ra => ra.id == ca.id)
        )),
        Promise.resolve(currentTemplateAttachments.filter(ca => 
          !retainedAttachments.find(ra => ra.id == ca.id)
        )),
        Promise.resolve(req.compressedFiles.map(file => ({
            id: getUniqueID(),
            filename: file.fieldname,
            content: file.pathUrl,
            contentType: file.fileType
        })))
    ]);
      
    const updatedAttachments = [...sortedAttachments, ...newAttachments];

    const obj = {
        mt_id: template.mt_id,
        mt_name: req.body.name,	
        mt_subject: req.body.subject,
        mt_content: req.body.message,	
        mt_attachment: JSON.stringify(updatedAttachments.length ? updatedAttachments : [])
    };

    await updateMarketingTemplateById(template.mt_id, obj);

    deletedAttachments.forEach(da => deleteFileAttachmentMulter(path.join(__basedir, "public", da.content)));

    return res.json({ status: true, message: "Template updated", data: obj })
})

exports.marketingTemplatesDelete = asyncHandler(async (req, res, next) => {

    const affectedRows = await deleteMarketingTemplates(req.body);
    
    return res.json({ status: Boolean(affectedRows), message: affectedRows ? "Template deleted" : "Template not found or has been deleted" })
})