
const { getApiWalletsBalance } = require("../../../helpers/admin");
const asyncHandler = require("../../../helpers/asyncHandler");
const { getUsersForDashboard, getDailyTransactionStats, getYearlyTransactionDataForChart, getMonthlyTransactionsByType, getMonthlyTransactionAmountsByUserType, getUserRegistrationsByYear } = require("../../../helpers/panelInfo");
const { adminGetServicesTransactions } = require("../../../helpers/servicesTransactions");

exports.adminDashboardGet = asyncHandler(async (req, res, next) => {

    return res.json({ status: true, data: {} })

    if(!req.query.type){
        const userGrowths = await getUsersForDashboard();
        const dailyTransactionStats = await getDailyTransactionStats();
        const yearlyTransactionsFC = await getYearlyTransactionDataForChart();
        const monthlyTransactionsByTypesFC = await getMonthlyTransactionsByType();
        const monthlyTransactionsByUserType = await getMonthlyTransactionAmountsByUserType();
        const yearlyUserRegistrations = await getUserRegistrationsByYear();

        const { transactions:recentTransactions } = await adminGetServicesTransactions({
            query: { type: "all", limit: 5, offset: 0 }
        });

        const walletsBalance = await getApiWalletsBalance()


        return res.json({ status: true, data: { userGrowths, dailyTransactionStats, yearlyTransactionsFC, monthlyTransactionsByTypesFC, monthlyTransactionsByUserType, yearlyUserRegistrations,recentTransactions, walletsBalance }})
    }else{

        let data;
        if(req.query.type == "yearlyTransactionsFC"){
            data = await getYearlyTransactionDataForChart(req.query.year);
        }
        else if(req.query.type == "monthlyTransactionsByTypesFC"){
            data = await getMonthlyTransactionsByType(req.query.month);
        }
        else if(req.query.type == "monthlyTransactionsByUserType"){
            data = await getMonthlyTransactionAmountsByUserType(req.query.month);
        }
        else if(req.query.type == "yearlyUserRegistrations"){
            data = await getUserRegistrationsByYear(req.query.year);
        }

        return res.json({ status: true, data })
    }
    
    
})