const asyncHandler = require("../../../helpers/asyncHandler");
const { getPaginationNextPrev, getNextOffset } = require("../../../helpers/pagination");
const { getContentRemovals, updateContentRemovals } = require("../../../helpers/contentRemoval");
const { delayFn } = require("../../../helpers/promise");

//ADMIN GET ALL CONTENT REMOVAL
exports.adminAllContentRemovalGet = asyncHandler(async (req, res, next) => {

    const limit = req.query.limit || parseInt(process.env.LIMIT), currentPage = parseInt(req.query.page) || 1, search = req.query.search, status = req.query.status;

    const { totalCount, data } = await getContentRemovals({
        query: { search, status, limit, offset: getNextOffset(currentPage, limit) }
    });

    const { prevPage, nextPage, totalPages } = getPaginationNextPrev({ page: currentPage, limit, totalCount});


    res.json({ status: true, data: { data, pagination: { currentPage, prevPage, nextPage, totalPages } }})
});


//APPROVE OR REJECT CONTENT REMOVAL
exports.adminModifyContentRemovalPut = asyncHandler(async (req, res, next) => {

    if(req.body.type == "approve"){
        const affectedRows = await updateContentRemovals(req.body.ids, { cr_status: 'approved'});

        //Send Approved Email

        return res.json({ status: true, message: `${affectedRows} Removal${affectedRows > 1 ? 's' : ''} Approved` });


    }else if(req.body.type == "reject"){
        const affectedRows = await updateContentRemovals(req.body.ids, { cr_status: 'rejected'});

        //Send Rejected Email
        return res.json({ status: true, message: `${affectedRows} Removal${affectedRows > 1 ? 's' : ''} Rejected` })


    }else return res.json({ status: false, message: "Invalid action" });


});
